using System;
using Server;
using Server.Engines.Craft;
using Server.Gumps;
using System.Collections;
using Server.ContextMenus;
using System.Collections.Generic;
using Server.Targeting;

namespace Server.Items
{
	[FlipableAttribute( 0x13E4, 0x13E3 )]
	public class AncientFletcherHammer : BaseTool
	{
		private int m_Bonus;
		private SkillMod m_SkillMod;

		[CommandProperty( AccessLevel.GameMaster )]
		public int Bonus
		{
			get
			{
				return m_Bonus;
			}
			set
			{
				m_Bonus = value;
				InvalidateProperties();

				if ( m_Bonus == 0 )
				{
					if ( m_SkillMod != null )
						m_SkillMod.Remove();

					m_SkillMod = null;
				}
				else if ( m_SkillMod == null && Parent is Mobile )
				{
					m_SkillMod = new DefaultSkillMod( SkillName.Fletching, true, m_Bonus );
					m_SkillMod.ObeyCap = false;
					((Mobile)Parent).AddSkillMod( m_SkillMod );
				}
				else if ( m_SkillMod != null )
				{
					m_SkillMod.Value = m_Bonus;
				}
			}
		}

		public override void OnAdded( object parent )
		{
			base.OnAdded( parent );

			if ( m_Bonus != 0 && parent is Mobile )
			{
				if ( m_SkillMod != null )
					m_SkillMod.Remove();

				m_SkillMod = new DefaultSkillMod( SkillName.Fletching, true, m_Bonus );
				m_SkillMod.ObeyCap = false;
				((Mobile)parent).AddSkillMod( m_SkillMod );
			}
		}

		public override void OnRemoved( object parent )
		{
			base.OnRemoved( parent );

			if ( m_SkillMod != null )
				m_SkillMod.Remove();

			m_SkillMod = null;
		}

		public override CraftSystem CraftSystem{ get{ return DefBowFletching.CraftSystem; } }
		
		[Constructable]
		public AncientFletcherHammer( int bonus ) : this( bonus, 600 )
		{
			Name = "Ancient Fletcher's Hammer";
			m_Bonus = bonus;
			Weight = 8.0;
			Layer = Layer.OneHanded;
			Hue = 1165;
		
		}

		[Constructable]
		public AncientFletcherHammer( int bonus, int uses ) : base( uses, 0x13E4 )
		{
			Name = "Ancient Fletcher's Hammer";
			m_Bonus = bonus;
			Weight = 8.0;
			Layer = Layer.OneHanded;
			Hue = 1165;
		}

		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );

			if ( m_Bonus != 0 )
				list.Add( 1060451, "#1044068\t{0}", m_Bonus.ToString() ); // ~1_skillname~ +~2_val~
		}
		
        public override void GetContextMenuEntries(Mobile from, List<ContextMenuEntry> list)
        {
            base.GetContextMenuEntries(from, list);

            list.Add(new CombineEntry(from, this));
        }

        public class CombineEntry : ContextMenuEntry
        {
            private Mobile m_From;
            private AncientFletcherHammer m_skb;

            public CombineEntry(Mobile from, AncientFletcherHammer skb)
                : base(0169, 1)//Connection	3000169
            {
                m_From = from;
                m_skb = skb;
            }

            public override void OnClick()
            {
                if (!m_skb.IsChildOf(m_From.Backpack))
                    m_From.SendLocalizedMessage(1042001); // That must be in your pack for you to use it.
                else
                    m_From.Target = new TargetInternal(m_skb);
            }
        }

        private class TargetInternal : Target
        {
            private AncientFletcherHammer m_skb;

            public TargetInternal(AncientFletcherHammer skb)
                : base(-1, true, TargetFlags.None)
            {
                m_skb = skb;

                CheckLOS = false;
            }

            protected override void OnTarget(Mobile from, object targeted)
            {
                if (m_skb.Deleted)
                    return;

                if (m_skb.IsChildOf(from.Backpack))
                {
                    if (targeted is AncientFletcherHammer && targeted != m_skb)
                    {
                        AncientFletcherHammer tg_skb = targeted as AncientFletcherHammer;

                        if (!tg_skb.IsChildOf(from.Backpack))
                            from.SendLocalizedMessage(1042001); // That must be in your pack for you to use it.
                        else if ( ( m_skb.BlessedFor != null || tg_skb.BlessedFor != null ) && !( m_skb.BlessedFor == from && tg_skb.BlessedFor == from ) )
                           from.SendMessage("Muzes spojit jen dva svoje nastroje");
                        else if ( m_skb.Bonus != tg_skb.Bonus )
                           from.SendMessage("Muzes spojit jen dva stejne nastroje");
                        else
                        {
                            m_skb.UsesRemaining += tg_skb.UsesRemaining;
                            tg_skb.Delete();
                            from.SendMessage("Nastroje byly skombinovany");
                        }
                    }
                    else
                        from.SendMessage("Musis zamerit druhy ancient hammer");
                }
                else
                {
                    from.SendLocalizedMessage(1042001); // That must be in your pack for you to use it.
                }
            }
        }

		public AncientFletcherHammer( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version

			writer.Write( (int) m_Bonus );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			switch ( version )
			{
				case 0:
				{
					m_Bonus = reader.ReadInt();
					break;
				}
			}

			if ( m_Bonus != 0 && Parent is Mobile )
			{
				if ( m_SkillMod != null )
					m_SkillMod.Remove();

				m_SkillMod = new DefaultSkillMod( SkillName.Fletching, true, m_Bonus );
				m_SkillMod.ObeyCap = false;
				((Mobile)Parent).AddSkillMod( m_SkillMod );
			}

			if ( Hue == 0 )
				Hue = 0x482;
		}
	}
}

